/*
 * SystemControl.h
 *
 *  Created on: 25.01.2013
 *      Author: georg
 */

#ifndef SYSTEMCONTROL_H_
#define SYSTEMCONTROL_H_

#include <iostream>
#include <sstream>
#include <fstream>
#include <sys/utsname.h>

class SystemControl {
public:
	SystemControl();
	virtual ~SystemControl();

	static int searchMissingDriver();

	static int searchFor_FTDI_kernelModul();

private:
	// The file where all loaded kernelmodules are listed
	static const std::string loadedKernelmodules;
	// Needed kernelmodule to open the virtual com port and connect to the FTDI chip
	static const std::string FTDI_kernelmodule;

	// The minimum supported kernelversion
	static const int firstKernelVersionNumber = 2;
	static const int secondKernelVersionNumber = 4;
};

#endif /* SYSTEMCONTROL_H_ */
